
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:04:13 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_EXT_MENU.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
#define _CRT_SECURE_NO_DEPRECATE /* To avoid Visual studio 2005 warnings*/
/************* Include Files ***********************************/

#include "SST_EXT_TST.h"
#include "ExtApp_qa_op_code.h"
#include "error.h"
#include "DX_VOS_Sem.h"
#include "SEPDriver.h" 
#include "ExtApp_qa_op_code.h"
#include "sst_types.h"

/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs *****************************/
/************************ Global Data **************************/
DxError_t      TST_Ext_TestStatus;
DxError_t      TST_Ext_Error;
DxByte_t       TST_Ext_Workspace[TST_WORKSPACE_SIZE_BYTES];
DxUint32_t     TST_Ext_WorkspaceSizeInBytes = TST_WORKSPACE_SIZE_BYTES;
DxVosFile      TST_Ext_MainDBFileHandle;
DxVosFile      TST_Ext_SecondaryDBFileHandle;
DxChar         TST_Ext_MainDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
DxChar         TST_Ext_SecondaryDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
SSTVersion_t   TST_Ext_Display_SST_version;
SSTVersion_t   TST_Ext_Display_SST_version;


#ifdef DX_NVS_RAM
DxChar TST_Ext_MainDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
DxChar TST_Ext_SecondaryDBPool[NVS_MEMORY_DATA_POOL_SIZE_IN_BYTES];
#endif
/*************** Private Functions Decleration *****************/
DxError_t SST_Ext_ATP_Init_SST_Tests( void );
DxError_t SST_Ext_ATP_TST_SST_Acceptance_ALL_TESTS( void );
/************************ Public Functions *********************/

/*****************************************************************************
 * Function Name:                                                           
 * 	SST_ATP_menu 		
 * 
 * Inputs:
 * 	none 
 *
 * Outputs:
 * 	DxError_t - Function error return		    					  		
 *
 * Description:																	
 * This function inits the SST, 
 * displays and dispatches SST ATP tests and terminates the SST when done
 *
 ******************************************************************************/
DxError_t SST_ExtApp_ATP_menu(void)
{		 
	/*Init SST for the tests */
		
    TST_Ext_Error = SST_Ext_ATP_Init_SST_Tests();
    
        
	TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Ext_Error,"SST_Ext_ATP_Init_SST_Tests",
										  "",
										  "");
	#if SST_TST_EXIT_ON_ERROR
		if (TST_Ext_TestStatus != TESTPASS)
			return TESTFAIL;
	#endif
   	

    if (TST_IsInteractive == 1)
    {
		/* Run All Tests */
		SST_Ext_ATP_TST_SST_Acceptance_ALL_TESTS();
	}
    else
    {
	    DxInt_t  Var;


	    for(;;)
	    {
		    for(;;)
		    {
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n\n\n--[Main Menu - ExtApp SST ATP tests ]----------------"));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [0] - Display SST Version                    "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n----------------------------------------------"));
                #if TST_USE_AUTHENTICATOR_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [1] - Password Authenticator                 "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [2] - RSA Authenticator                      "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [3] - AES Key Authenticator                  "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [4] - ECC Key Authenticator                  "));
                #endif
                #if TST_USE_DATA_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [5] - Basic Data Operations                  "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [6] - Binding & Writing Permissions          "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [7] - Data replace operation          "));
                #endif
                #if TST_USE_SPECIAL_DATA_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [8] - Special Data Operations AES            "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [9] - Special Data Operations DES            "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [a] - Special Data Operations HMAC           "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [b] - Special Data Operations RSA            "));
                #endif
                #if TST_USE_DATA_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [c] - Read Only Data                         "));                    
                #endif
                #if TST_USE_INDEX_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [d] - Index Services                         "));
                #endif
                #if TST_USE_ITERTOR_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [e] - Iterator Services                      "));
                #endif
                #if TST_USE_INIT_TERMINATE_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [f] - Init/Terminate                         "));
                #endif
                #if TST_USE_ROLL_BACK_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [g] - Transaction RollBack                   "));
                #endif
                #if TST_USE_CRYS_SST_SYM_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [h] - CRYS SST operations - AES               "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [i] - CRYS SST operations - DES               "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [j] - CRYS SST operations - HMAC              "));
                #endif
                #if TST_USE_CRYS_SST_ASYM_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [k] - CRYS SST operations - RSA               "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [l] - CRYS SST RSA OAEP_ENCDEC operations     "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [m] - CRYS SST RSA primitive operations       "));
                #endif
                #if TST_USE_SST_UTIL_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [n] - SST_TST_ATP_UtilityHandle               "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [o] - SST_TST_ATP_UtilitySize                 "));
                #endif
                #if TST_USE_SST_MM_MODULE
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [p] - SST mode management operation           "));
                #endif
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [T] - Run All ATP Tests                       "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n [Z] - End Of Tests                            "));
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n-----------------------------------------------\n\n"));
                GET_NON_WHITE_SPACE_CHAR(Var);
                ATP_LOG_TST_PRINT((SST_TST_MSG,"\n Test = %c\n",Var));
                if (Var<='z')
                            break;
                else
                {
                    ATP_LOG_TST_PRINT((SST_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
                }
		     };

		        switch(Var)
		        {
                       
                               
                      
                        case '1':
                               SST_Ext_ATP_PasswordAuthenticator();
                                break; 
                               
                        case '2':
                                SST_Ext_ATP_RsaAsymAuthenticator();
                                break; 
                                
                        case '3':
                                SST_Ext_ATP_AesKeyAsymAuthenticator();
                                break;
                        case '4':
                                SST_Ext_ATP_ECCAsymAuthenticator();
                                break;
                       
                         #if TST_USE_DATA_MODULE
                        case '5':
                                SST_Ext_ATP_BasicDataOp();
                                break;  
                                                           
                                                      
                        case '6':
                                SST_Ext_ATP_BindingWritingPermissions();
                                break;
                                
                        case '7':
                                SST_Ext_ATP_DataReplace();
                                break;
                        #endif
                        
                        #if TST_USE_SPECIAL_DATA_MODULE
                        case '8':
                                SST_Ext_ATP_SpecialDataOpAES();
                                break;
                                
                        case '9':
                                SST_Ext_ATP_SpecialDataOpDES();
                                break;
                        case 'a':
                                SST_Ext_ATP_SpecialDataOpHMAC();
                                break;
                        case 'b':
                                SST_Ext_ATP_SpecialDataOpRSA();
                                break;
                                
                        #endif
                        
                        #if TST_USE_DATA_MODULE
                        case 'c':
                                SST_Ext_ReadOnlyData();
                                break;         
                        #endif
                        
                        
                        #if TST_USE_INDEX_MODULE
                        case 'd':
                                SST_Ext_ATP_Index();
                                break;
                        #endif
                        
                        
                        #if TST_USE_ITERTOR_MODULE
                        case 'e':
                                SST_Ext_ATP_Iterator();
                                break;
                        #endif
                        
                        #if TST_USE_INIT_TERMINATE_MODULE
                        case 'f':
                                SST_Ext_ATP_InitTerminate();
                                break;
                        #endif
                        #if TST_USE_ROLL_BACK_MODULE
                        case 'g':
                                SST_Ext_ATP_RollBack();
                                break;
                        #endif
                       
                        #if TST_USE_CRYS_SST_SYM_MODULE
                        
                        case 'h':
                                CRYS_SST_Ext_ATP_AES();
                                break ;
                        case 'i':
                                CRYS_SST_Ext_ATP_DES();
                                break ;
                        case 'j':
                                CRYS_SST_Ext_ATP_HMAC();
                                break ;
                        #endif
                        
                        #if TST_USE_CRYS_SST_ASYM_MODULE
                        case 'k':
                                CRYS_SST_Ext_ATP_RSA();
                                break ;
                                
                        case 'l':
                                CRYS_SST_Ext_ATP_RSA_OAEP_ENCDEC();
                                break ;
                        case 'm':
                                CRYS_SST_Ext_ATP_RSA_Prim();
                                break ;
                        #endif
                        
                        #if TST_USE_SST_UTIL_MODULE
                        case 'n':
                            SST_Ext_ATP_UtilityHandle();
                            break ;
                        case 'o':
                            SST_Ext_ATP_UtilitySize();
                            break ;
                       
                        #endif
                        
                        #if TST_USE_SST_MM_MODULE
                        case 'p':
                            SST_Ext_ATP_MM();
                            break ;
                        #endif
                        case 'T':
                                SST_Ext_ATP_TST_SST_Acceptance_ALL_TESTS();
                                break;                            
                        case 'Z':
								TST_Ext_Error = SST_Terminate();
								TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Ext_Error,"SST_Terminate",
																	  "",
																	  "");
								if (TST_Ext_TestStatus != TESTPASS)
									return TESTFAIL;

                                TST_Ext_TestStatus = DX_VOS_FClose(TST_Ext_MainDBFileHandle);
                                if (TST_Ext_TestStatus == DX_FAILURE)
                                {
                                    DX_VOS_Printf("CANT CLOSE MAIN FILE \n");
                                    return TESTFAIL;
                                }

                                TST_Ext_TestStatus = DX_VOS_FClose(TST_Ext_SecondaryDBFileHandle);
                                if (TST_Ext_TestStatus == DX_FAILURE)
                                {
                                    DX_VOS_Printf("CANT CLOSE SECONDARY FILE \n");
                                    return TESTFAIL;
                                }
                                DX_VOS_Printf("\n End of SST tests \n");
                                break ;
                                
                        default:
                            ATP_LOG_TST_PRINT((SST_TST_MSG,"\n*** Error in test selection [%c]\n",Var));
		        }
		        if(Var =='Z')
		        break;
	        };
    }
	return TESTPASS;
 }/* End of SST_TST_main*/


/*****************************************************************************
 * Function Name:                                                           
 * 	SST_Ext_ATP_TST_Run_All_ATP_Tests 		
 * 
 * Inputs:
 * 	none 
 *
 * Outputs:
 * 	DxError_t - Function error return		    					  		
 *
 * Description:																	
 * This function inits the SST, runs all of the SST Acceptance tests and terminates the SST
 *
 ******************************************************************************/
DxError_t SST_Ext_ATP_TST_Run_All_ATP_Tests( void )
{
	DxError_t TST_Result = DX_SUCCESS;

	TST_Result = SST_Ext_ATP_Init_SST_Tests();
	TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Result,"SST_Ext_ATP_Init_SST_Tests",
									  "",
									  "");
    if (TST_Ext_TestStatus != TESTPASS)
		return TESTFAIL;

	TST_Result = SST_Ext_ATP_TST_SST_Acceptance_ALL_TESTS();
	TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Result,"SST_Ext_ATP_TST_SST_Acceptance_ALL_TESTS",
										  "",
										  "");
	TST_Result = SST_Terminate();
	TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Result,"SST_Terminate",
										  "",
										  "");
	if (TST_Ext_TestStatus != TESTPASS)
		return TESTFAIL;
	return TESTPASS;
}

/********************** Private Functions **********************/

/*****************************************************************************
 * Function Name:                                                           
 * 	SST_Ext_ATP_TST_SST_Acceptance_ALL_TESTS 		
 * 
 * Inputs:
 * 	none 
 *
 * Outputs:
 * 	DxError_t - Function error return		    					  		
 *
 * Description:																	
 * This function runs all of the SST Acceptance tests
 *
 ******************************************************************************/
DxError_t SST_Ext_ATP_TST_SST_Acceptance_ALL_TESTS(void)
{	
    DxError_t TST_ATP_SST_Error = TESTPASS;

   
    TST_Ext_Error = SST_Ext_ATP_PasswordAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
       
    TST_Ext_Error = SST_Ext_ATP_RsaAsymAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
    TST_Ext_Error = SST_Ext_ATP_AesKeyAsymAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
    TST_Ext_Error = SST_Ext_ATP_ECCAsymAuthenticator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
    
    TST_Ext_Error = SST_Ext_ATP_BasicDataOp();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_BindingWritingPermissions();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_DataReplace();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
                
    TST_Ext_Error = SST_Ext_ATP_SpecialDataOpAES();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_SpecialDataOpDES();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_SpecialDataOpHMAC();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_SpecialDataOpRSA();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
     
    TST_Ext_Error = SST_Ext_ReadOnlyData();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_Index();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_Iterator();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
        TST_Ext_Error = SST_Ext_ATP_InitTerminate();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
    
         TST_Ext_Error = SST_Ext_ATP_RollBack();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
         TST_Ext_Error = CRYS_SST_Ext_ATP_AES();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
         TST_Ext_Error = CRYS_SST_Ext_ATP_DES();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
         TST_Ext_Error = CRYS_SST_Ext_ATP_HMAC();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
         TST_Ext_Error = CRYS_SST_Ext_ATP_RSA();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
         TST_Ext_Error = CRYS_SST_Ext_ATP_RSA_OAEP_ENCDEC();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
         TST_Ext_Error = SST_Ext_ATP_UtilityHandle();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
    
         TST_Ext_Error = SST_Ext_ATP_UtilitySize();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
      
    TST_Ext_Error = SST_Ext_ATP_MM();
    TST_ATP_SST_Error = TST_ATP_SST_Error+TST_Ext_Error;

    #if SST_TST_EXIT_ON_ERROR
	    if (TST_ATP_SST_Error != TESTPASS)
			    return 	TST_ATP_SST_Error;
    #endif
    
   

		/*Check if all tests pass*/
		if (TST_ATP_SST_Error != TESTPASS)
			{
				ATP_LOG_TST_PRINT((SST_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE SST TESTS FAILED !!!!!!!!!!!!!!!!!!!!\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
			}
			else
			{
				ATP_LOG_TST_PRINT((SST_TST_MSG,"\n \n******************************************************************\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"******************************************************************\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"********* ALL OF THE SST Acceptance TESTS PASS   :-)         *********\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"******************************************************************\n"));
				ATP_LOG_TST_PRINT((SST_TST_MSG,"******************************************************************\n"));						
			}	
		return TST_ATP_SST_Error;

}



/*****************************************************************************
 * Function Name:                                                           
 * 	SST_Ext_ATP_Init_SST_Tests 		
 * 
 * Inputs:
 * 	none 
 *
 * Outputs:
 * 	DxError_t - Function error return		    					  		
 *
 * Description:																	
 * This function inits 
 *
 ******************************************************************************/
DxError_t SST_Ext_ATP_Init_SST_Tests()
{
	#ifndef DX_NVS_RAM
	/*Delete old DB file to start a new clean test*/
   	DX_VOS_FDelete(SST_DB_FILENAME);
#endif
   	
    TST_Ext_Error = SST_VersionGet(&TST_Ext_Display_SST_version);

   	TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Ext_Error,"SST_VersionGet",
										  "",
										  "");
	#if SST_TST_EXIT_ON_ERROR
		if (TST_Ext_TestStatus != TESTPASS)
			return TESTFAIL;
	#endif
    
	/*open files and get files handle*/
#ifndef DX_NVS_RAM
	TST_Ext_TestStatus = DX_VOS_FOpen(&TST_Ext_MainDBFileHandle,SST_DB_FILENAME ,"w+b");
	if (TST_Ext_TestStatus == DX_FAILURE)
	{
		DX_VOS_Printf("CANT OPEN MAIN FILE \n");
		return TESTFAIL;
	}

	TST_Ext_TestStatus = DX_VOS_FOpen(&TST_Ext_SecondaryDBFileHandle,SST_DB_FILENAME_SECOND ,"w+b");
	if (TST_Ext_TestStatus == DX_FAILURE)
	{
		DX_VOS_Printf("CANT OPEN SECONDARY FILE \n");
		return TESTFAIL;
	}
#else
    TST_Ext_MainDBFileHandle        = (DxVosFile)TST_Ext_MainDBPool;
    TST_Ext_SecondaryDBFileHandle   = (DxVosFile)TST_Ext_SecondaryDBPool;
#endif

    TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Ext_Error,"Get DB Files Handles",
										  "",
										  "");

   	TST_Ext_Error = SST_Init( (DxNvsMemoryId_t)TST_Ext_MainDBFileHandle,
				          (DxNvsMemoryId_t)TST_Ext_SecondaryDBFileHandle,
						  DX_NULL,
						  TST_Ext_Workspace,
						  TST_Ext_WorkspaceSizeInBytes);

	TST_Ext_TestStatus = TST_CheckErrorReturn(TST_Ext_Error,"SST_Init",
										  "",
										  "");
	#if SST_TST_EXIT_ON_ERROR
		if (TST_Ext_TestStatus != TESTPASS)
			return TESTFAIL;
	#endif
	return TESTPASS;
}




